<?php

/**
 * @package SP Page Builder
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('restricted aceess');

class SppagebuilderAddonTestimonialpro extends SppagebuilderAddons {

    public function render() {
        $class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
        $style = (isset($this->addon->settings->style) && $this->addon->settings->style) ? $this->addon->settings->style : '';

        //Options
        $autoplay = (isset($this->addon->settings->autoplay) && $this->addon->settings->autoplay) ? ' data-sppb-ride="sppb-carousel"' : '';
        $arrows = (isset($this->addon->settings->arrows) && $this->addon->settings->arrows) ? $this->addon->settings->arrows : '';
        $controllers = (isset($this->addon->settings->controllers) && $this->addon->settings->controllers) ? $this->addon->settings->controllers : 0;

        //Output
        $output = '<div id="sppb-testimonial-pro-' . $this->addon->id . '" class="sppb-carousel sppb-testimonial-pro sppb-slide sppb-text-center' . $class . '"' . $autoplay . '>';

        if ($controllers) {
            $output .= '<ol class="sppb-carousel-indicators">';
            foreach ($this->addon->settings->sp_testimonialpro_item as $key1 => $value) {
                $output .= '<li data-sppb-target="#sppb-carousel-' . $this->addon->id . '" ' . (($key1 == 0) ? ' class="active"' : '' ) . '  data-sppb-slide-to="' . $key1 . '"></li>' . "\n";
            }
            $output .= '</ol>';
        }

        $output .= '<div class="sppb-carousel-inner">';

        foreach ($this->addon->settings->sp_testimonialpro_item as $key => $value) {
            $avatarSrc = "";
            if (isset($value->avatar)) {
                if (is_object($value->avatar)) {
                    $avatarSrc = $value->avatar->src;
                } elseif (is_string($value->avatar)) {
                    $avatarSrc = $value->avatar;
                }
                if(strpos($avatarSrc, "http://") === 0 || strpos($avatarSrc, "https://") === 0){
                    $avatarSrc = $avatarSrc;
                } else {
                    $avatarSrc = JURI::base() . $avatarSrc;
                }
            }

            $output .= '<div class="sppb-item ' . (($key == 0) ? ' active' : '') . '">';
            $title = '<strong class="pro-client-name">' . $value->title . '</strong>';

            if ($value->url)
                $title .= ' - <span class="pro-client-url">' . $value->url . '</span>';
            if ($value->avatar)
                $output .= '<img class="sppb-img-responsive sppb-avatar ' . $value->avatar_style . '" src="' . $avatarSrc . '" alt="">';
            $output .= '<div class="sppb-testimonial-message">' . $value->message . '</div>';
            if ($title)
                $output .= '<div class="sppb-testimonial-client">' . $title . '</div>';

            $output .= '</div>';
        }
        $output .= '</div>';

        if ($arrows) {
            $output .= '<a href="#sppb-testimonial-pro-' . $this->addon->id . '" class="left sppb-carousel-control" data-slide="prev"><i class="fa fa-angle-left"></i></a>';
            $output .= '<a href="#sppb-testimonial-pro-' . $this->addon->id . '" class="right sppb-carousel-control" data-slide="next"><i class="fa fa-angle-right"></i></a>';
        }

        $output .= '</div>';

        return $output;
    }

    public static function getTemplate() {
        $output = '
            <#
                let contentClass = (!_.isEmpty(data.class) && data.class) ? data.class : "";
                let style = (!_.isEmpty(data.style) && data.style) ? data.style : "";
                let autoplay = (!_.isEmpty(data.autoplay) && data.autoplay) ? \' data-sppb-ride="sppb-carousel"\' : \' data-sppb-ride=""\';
                let arrows = (typeof data.arrows !=="undefined") ? data.arrows : 0;
                let controllers = (typeof data.controllers !=="undefined") ? data.controllers : 0;
            #>

                <div id="sppb-testimonial-pro-{{data.id}}" class="sppb-carousel sppb-testimonial-pro sppb-slide sppb-text-center {{contentClass}}" {{{autoplay}}}>

                <# if (controllers > 0) { #>
                    <ol class="sppb-carousel-indicators">
                    <# _.each (data.sp_testimonialpro_item, function(value, key) {
                    let activeClass;
                    if(key === 0){
                        activeClass = " active";
                    } else {
                        activeClass = "";
                    }
                    #>
                        <li data-sppb-target="#sppb-carousel-{{data.id}}" class="{{activeClass}}" data-sppb-slide-to="{{key}}"></li>
                    <# }) #>
                    </ol>
                <# } #>

                <div class="sppb-carousel-inner">

                <# _.each (data.sp_testimonialpro_item, function(value, key) {
                    let activeClass;
                    if(key === 0){
                        activeClass = " active";
                    } else {
                        activeClass = "";
                    }
                #>
                    <div class="sppb-item {{activeClass}}">

                    <#
                    let title = \'<strong class="pro-client-name">\' + value.title + \'</strong>\';
                    if (value.url){
                        title += \' - <span class="pro-client-url">\' + value.url + \'</span>\';
                    }
                    let value_avatar = "";
                    if(typeof value.avatar !== "undefined") {
                        if(typeof value.avatar === "object"){
                            if(value.avatar.src.indexOf("http://") === 0 || value.avatar.src.indexOf("https://") === 0){
                                value_avatar = `src=${value.avatar.src}`;
                            } else {
                                value_avatar = `src=${pagebuilder_base + value.avatar.src}`;
                            }
                        } else {
                            if(value.avatar.indexOf("http://") === 0 || value.avatar.indexOf("https://") === 0){
                                value_avatar = `src=${value.avatar}`;
                            } else {
                                value_avatar = `src=${pagebuilder_base + value.avatar}`;
                            }
                        }
                    }
                    if (value.avatar){
                    #>
                        <img class="sppb-img-responsive sppb-avatar {{value.avatar_style}}" {{value_avatar}} alt="">
                    <# } #>

                    <div class="sppb-testimonial-message">{{{value.message}}}</div>

                    <# if (title) { #>
                        <div class="sppb-testimonial-client">{{{title}}}</div>
                    <# } #>

                    </div>
                <# }) #>
                </div>

                <# if (arrows > 0) { #>
                    <a href="#sppb-testimonial-pro-{{data.id}}" class="left sppb-carousel-control" data-slide="prev"><i class="fa fa-angle-left"></i></a>
                    <a href="#sppb-testimonial-pro-{{data.id}}" class="right sppb-carousel-control" data-slide="next"><i class="fa fa-angle-right"></i></a>
                <# } #>
                </div>
                ';
        return $output;
    }

}
