<?php

/**
 * @package Onepage
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2016 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('resticted aceess');

class SppagebuilderAddonTeams extends SppagebuilderAddons {

    public function render() {
        $class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
        $team_items = (isset($this->addon->settings->sp_teams_item) && is_array($this->addon->settings->sp_teams_item)) ? $this->addon->settings->sp_teams_item : array();


        $before_text = (isset($this->addon->settings->before_text) && $this->addon->settings->before_text) ? $this->addon->settings->before_text : '';

        $output = '';
        $output = '<div class="sppb-addon sppb-addon-teams">';

        if ($before_text) {
            // Before text
            $output .= '<div class="sppb-team-before-text sppb-text-center" >';
            $output .= '<p class="sppb-center sppb-lead">' . $before_text . '</p>';
            $output .= '</div>';
        }

        // Start Teams
        $output .= '<div class="sppb-teams-wrapper ' . $class . '">';

        foreach (array_chunk($team_items, 2) as $chunk_key => $team_items) {

            //array items
            $output .= '<div class="sppb-teams sppb-row">';

            foreach ($team_items as $key => $sppbTeam) {
                $sppbTeamImage = "";
                if (isset($sppbTeam->image)) {
                    if (is_object($sppbTeam->image)) {
                        $sppbTeamImage = $sppbTeam->image->src;
                    } elseif (is_string($sppbTeam->image)) {
                        $sppbTeamImage = $sppbTeam->image;
                    }
                    if(strpos($sppbTeamImage, "http://") === 0 || strpos($sppbTeamImage, "https://") === 0){
                        $sppbTeamImage = $sppbTeamImage;
                    } else {
                        $sppbTeamImage = JURI::base() . $sppbTeamImage;
                    }
                }
                $output .= '<div class="sppb-team sppb-col-sm-6">';
                $output .= '<div class="sppb-team-wrapper">';
                $output .= '<div class="sppb-team-img">';
                $output .= '<img class="img-thumbnail sppb-img-responsive" src="' . $sppbTeamImage . '" alt=" ' . $sppbTeam->title . ' ">';
                $output .= '</div>'; //.sppb-team-img

                $output .= '<div class="sppb-team-info">';
                // Has name
                if ($sppbTeam->title) {
                    $output .= '<h3 class="sppb-team-name"> ' . $sppbTeam->title . ' </h3>';
                }

                //has designation
                if ($sppbTeam->designation) {
                    $output .= '<p class="sppb-designation"> ' . $sppbTeam->designation . ' </p>';
                }

                //has intro text
                if ($sppbTeam->introtext) {
                    $output .= '<p class="sppb-introtext"> ' . $sppbTeam->introtext . ' </p>';
                }

                //has social
                if ($sppbTeam->facebook || $sppbTeam->twitter || $sppbTeam->google_plus || $sppbTeam->youtube || $sppbTeam->linkedin || $sppbTeam->pinterest || $sppbTeam->flickr || $sppbTeam->dribbble || $sppbTeam->behance || $sppbTeam->instagram
                ) {
                    $output .= '<div class="sppb-team-social-icons">';

                    // Has facebook
                    if ($sppbTeam->facebook ?? '') {
                        $output .= '<a target="_blank" href="' . $sppbTeam->facebook . '" ><i class="fa fa-facebook"></i></a>';
                    }
                    // Has twitter
                    if ($sppbTeam->twitter ?? '') {
                        $output .= '<a target="_blank" href="' . $sppbTeam->twitter . '" ><i class="fa fa-twitter"></i></a>';
                    }
                    // Has google plus
                    if ($sppbTeam->google_plus ?? '') {
                        $output .= '<a target="_blank" href="' . $sppbTeam->google_plus . '" ><i class="fa fa-google-plus"></i></a>';
                    }
                    // Has youtube
                    if ($sppbTeam->youtube ?? '') {
                        $output .= '<a target="_blank" href="' . $sppbTeam->youtube . '" ><i class="fa fa-youtube"></i></a>';
                    }
                    // Has linkedin
                    if ($sppbTeam->linkedin ?? '') {
                        $output .= '<a target="_blank" href="' . $sppbTeam->linkedin . '" ><i class="fa fa-linkedin"></i></a>';
                    }
                    // Has pinterest
                    if ($sppbTeam->pinterest ?? '') {
                        $output .= '<a target="_blank" href="' . $sppbTeam->pinterest . '" ><i class="fa fa-pinterest"></i></a>';
                    }
                    // Has flickr
                    if ($sppbTeam->flickr ?? '') {
                        $output .= '<a target="_blank" href="' . $sppbTeam->flickr . '" ><i class="fa fa-flickr"></i></a>';
                    }
                    // Has dribbble
                    if ($sppbTeam->dribbble ?? '') {
                        $output .= '<a target="_blank" href="' . $sppbTeam->dribbble . '" ><i class="fa fa-dribbble"></i></a>';
                    }
                    // Has behance
                    if ($sppbTeam->behance ?? '') {
                        $output .= '<a target="_blank" href="' . $sppbTeam->behance . '" ><i class="fa fa-behance"></i></a>';
                    }
                    // Has instagram
                    if ($sppbTeam->instagram ?? '') {
                        $output .= '<a target="_blank" href="' . $sppbTeam->instagram . '" ><i class="fa fa-instagram"></i></a>';
                    }

                    $output .= '</div>'; //.sppb-team-social-icons
                }
                $output .= '</div>'; //.sppb-team-info


                $output .= '</div>'; //.sppb-team-wrapper
                $output .= '</div>'; // ./sppb-team
            }
            $output .= '</div>'; //.sppb-teams sppb-row
        }
        $output .= '</div>'; //.sppb-teams-wrapper
        $output .= '</div>'; //.sppb-addon-teams

        return $output;
    }

    public static function getTemplate() {
        $output = '
            <#
                let contentClass = (!_.isEmpty(data.class) && data.class) ? data.class : "";
                let team_items = (!_.isEmpty(data.sp_teams_item) && data.sp_teams_item) ? data.sp_teams_item : [];
                let before_text = (!_.isEmpty(data.before_text) && data.before_text) ? data.before_text : "";
            #>
                <div class="sppb-addon sppb-addon-teams">

                <# if (before_text) { #>
                    <div class="sppb-team-before-text sppb-text-center">
                    <p class="sppb-center sppb-lead">{{{before_text}}}</p>
                    </div>
                <# } #>

                <div class="sppb-teams-wrapper {{contentClass}}">

                <# _.each (_.chunk(team_items, 2), function(team_items, chunk_key) { #>

                    <div class="sppb-teams sppb-row">

                    <# _.each (team_items, function(sppbTeam, key) { #>
                        <#
                        let sppbTeamImage = "";
                        if(typeof sppbTeam.image !== "undefined") {
                            if(typeof sppbTeam.image === "object"){
                                if(sppbTeam.image.src.indexOf("http://") === 0 || sppbTeam.image.src.indexOf("https://") === 0){
                                    sppbTeamImage = `src=${sppbTeam.image.src}`;
                                } else {
                                    sppbTeamImage = `src=${pagebuilder_base + sppbTeam.image.src}`;
                                }
                            } else {
                                if(sppbTeam.image.indexOf("http://") === 0 || sppbTeam.image.indexOf("https://") === 0){
                                    sppbTeamImage = `src=${sppbTeam.image}`;
                                } else {
                                    sppbTeamImage = `src=${pagebuilder_base + sppbTeam.image}`;
                                }
                            }
                        }
                        #>
                        <div class="sppb-team sppb-col-sm-6">
                        <div class="sppb-team-wrapper">
                        <div class="sppb-team-img">
                        <img class="img-thumbnail sppb-img-responsive" {{sppbTeamImage}} alt=" {{sppbTeam.title}} ">
                        </div>

                        <div class="sppb-team-info">

                        <# if (sppbTeam.title) { #>
                            <h3 class="sppb-team-name"> {{sppbTeam.title}} </h3>
                        <# }

                        if (sppbTeam.designation) {
                        #>
                            <p class="sppb-designation"> {{sppbTeam.designation}} </p>
                        <# }

                        if (sppbTeam.introtext) {
                        #>
                            <p class="sppb-introtext"> {{sppbTeam.introtext}} </p>
                        <# }

                        if (sppbTeam.facebook || sppbTeam.twitter || sppbTeam.google_plus || sppbTeam.youtube || sppbTeam.linkedin || sppbTeam.pinterest || sppbTeam.flickr || sppbTeam.dribbble || sppbTeam.behance || sppbTeam.instagram) {
                        #>
                            <div class="sppb-team-social-icons">

                            <# if (sppbTeam.facebook) { #>
                                <a target="_blank" href="{{sppbTeam.facebook}}"><i class="fa fa-facebook"></i></a>
                            <# }
                            if (sppbTeam.twitter) {
                            #>
                                <a target="_blank" href="{{sppbTeam.twitter}}"><i class="fa fa-twitter"></i></a>
                            <# }
                            if (sppbTeam.google_plus) {
                            #>
                                <a target="_blank" href="{{sppbTeam.google_plus}}"><i class="fa fa-google-plus"></i></a>
                            <# }
                            if (sppbTeam.youtube) {
                            #>
                                <a target="_blank" href="{{sppbTeam.youtube}}"><i class="fa fa-youtube"></i></a>
                            <# }
                            if (sppbTeam.linkedin) {
                            #>
                                <a target="_blank" href="{{sppbTeam.linkedin}}"><i class="fa fa-linkedin"></i></a>
                            <# }
                            if (sppbTeam.pinterest) {
                            #>
                                <a target="_blank" href="{{sppbTeam.pinterest}}"><i class="fa fa-pinterest"></i></a>
                            <# }
                            if (sppbTeam.flickr) {
                            #>
                                <a target="_blank" href="{{sppbTeam.flickr}}"><i class="fa fa-flickr"></i></a>
                            <# }
                            if (sppbTeam.dribbble) {
                            #>
                                <a target="_blank" href="{{sppbTeam.dribbble}}"><i class="fa fa-dribbble"></i></a>
                            <# }
                            if (sppbTeam.behance) {
                            #>
                                <a target="_blank" href="{{sppbTeam.behance}}"><i class="fa fa-behance"></i></a>
                            <# }
                            if (sppbTeam.instagram) {
                            #>
                                <a target="_blank" href="{{sppbTeam.instagram}}"><i class="fa fa-instagram"></i></a>
                            <# } #>

                            </div>
                        <# } #>
                        </div>

                        </div>
                        </div>
                    <# }) #>
                    </div>
                <# }) #>
                </div>
                </div>
                ';
        return $output;
    }

}
