<?php

/**
 * @package Qubic
 * @author JoomShaper http://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
 */
//no direct accees
defined('_JEXEC') or die('resticted aceess');

require_once JPATH_ROOT . '/components/com_sppagebuilder/helpers/articles.php';

class SppagebuilderAddonLatest_post extends SppagebuilderAddons {

    public function render() {
        $class = (isset($this->addon->settings->class) && $this->addon->settings->class) ? $this->addon->settings->class : '';
        $title = (isset($this->addon->settings->title) && $this->addon->settings->title) ? $this->addon->settings->title : '';
        $heading_selector = (isset($this->addon->settings->heading_selector) && $this->addon->settings->heading_selector) ? $this->addon->settings->heading_selector : 'h3';

        $item_limit = (isset($this->addon->settings->item_limit) && $this->addon->settings->item_limit) ? $this->addon->settings->item_limit : '';
        $ordering = (isset($this->addon->settings->ordering) && $this->addon->settings->ordering) ? $this->addon->settings->ordering : 'latest';
        $post_type = (isset($this->addon->settings->post_type) && $this->addon->settings->post_type) ? $this->addon->settings->post_type : '';
        $catid = (isset($this->addon->settings->category) && $this->addon->settings->category) ? $this->addon->settings->category : '';

        $items = SppagebuilderHelperArticles::getArticles($item_limit, $ordering, $catid, TRUE, $post_type);


        //start output
        $output = '<div class="sppb-addon sppb-addon-latest-posts ' . $class . '">';
        $output .= '<div class="sppb-addon-content">';
        $output .= '<div class="latest-posts clearfix">';
        $output .= '<' . $heading_selector . ' class="sppb-addon-title">' . $title . '</' . $heading_selector . '>';

        $output .= '<div class="sppb-row">';
        foreach (array_chunk($items, 2) as $items) {
            foreach ($items as $item) {

                $image = '';
                //image
                if (isset($item->image_thumbnail) && $item->image_thumbnail) {
                    $image = JURI::root() . $item->image_thumbnail;
                } elseif (isset($images->image_intro) && !empty($images->image_intro)) {
                    $image = $images->image_intro;
                } elseif (isset($images->image_fulltext) && !empty($images->image_fulltext)) {
                    $image = $images->image_fulltext;
                }


                $output .= '<div class="latest-post sppb-col-sm-4" >';
                $output .= '<div class="latest-post-inner match-height">';

                $output .= '<div class="entry-meta"><span class="entry-date"> ' . JHtml::_('date', $item->created, 'DATE_FORMAT_LC3') . '</span></div>';
                $output .= '<h2 class="entry-title"><a href="' . $item->link . '">' . $item->title . '</a></h2>';
                $output .= '<div class="post-author"> <span class="sppb-meta-author" itemprop="name">' . JText::_('COM_SPPAGEBUILDER_ADDON_SF_POSTED_BY') . $item->username . '</span> </div>';

                $output .= '</div>';
                $output .= '</div>';
            } // END:: items foreach
        } // END:: array_chunk
        $output .= '</div>'; //.sppb-row

        $output .= '</div>'; // /.latest-posts
        $output .= '</div>'; // /.sppb-addon-content
        $output .= '</div>'; // /.sppb-addon-latest-posts

        return $output;
    }

}
